const express = require("express");
const router = express.Router();
const staffRoleController = require("../controllers/staffRoleController");
const authController = require("../controllers/authController");

router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router
  .route("/")
  .get(staffRoleController.getAllRoles)
  .post(staffRoleController.createRole);

router
  .route("/:id")
  .patch(staffRoleController.updateRole)
  .delete(staffRoleController.deleteRole);

module.exports = router;
